'use strict';

/* --------------------------------------------------------------
 customizer.js 2022-05-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2022 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gambio.widgets.module('customizer', [jse.source + '/vendor/jquery-ui-dist/jquery-ui.min.js', gambio.source + '/libs/events'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $body = $('body'),
        $window = $(window),
        ajax = null,
        defaults = {
        requestUrl: 'request_port.php?module=GPrint',
        uidSelector: '#gm_gprint_random',
        page: 'product'
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    var $btn = $("[name=btn-add-to-cart]");
    var $btnFake = $(".btn-add-to-cart-fake");
    var fakeOrigLabel = $btnFake.html();

    /**
     * Add customizer data to cart or wish list.
     *
     * @private
     */
    var _addCustomizerData = function _addCustomizerData(e, d) {

        var formdata = jse.libs.form.getData($this, null, true),
            dataset = $.extend({ 'mode': 'frontend', 'action': e.data.action }, d.dataset, {}, formdata),
            promises = [],
            attribute_id_strings = [],
            add_attribute_string_function = function add_attribute_string_function() {
            var optionId = $(this).attr('name').replace(/(id|modifiers\[attribute\])\[(\d+)\]/, '$2');
            attribute_id_strings.push('{' + optionId + '}' + $(this).val());
        };

        $('.customizer select[name^="id["], .customizer input[name^="id["]:checked').each(add_attribute_string_function);
        $('.customizer select[name^="modifiers[attribute]["], .customizer input[name^="modifiers[attribute]["]:checked').each(add_attribute_string_function);
        $('.customizer input[type=radio][name^="modifiers[attribute]["]:checked').each(add_attribute_string_function);
        $('.customizer input[type=hidden][name^="modifiers[attribute]["]').each(add_attribute_string_function);

        //  removing duplicated ids
        attribute_id_strings = attribute_id_strings.filter(function (value, index, self) {
            return self.indexOf(value) === index;
        });

        var attributeIdsString = attribute_id_strings.join('');

        dataset.products_id = dataset.products_id + attributeIdsString + '{' + e.data.random.match(/\d+/) + '}0';

        $this.find('input[type="file"]').each(function () {
            if ($(this).get(0).files.length > 0) {
                var deferred = $.Deferred();
                promises.push(deferred);

                $(this).hide();
                $(this).parent().append('<img src="gm/images/gprint/upload.gif" width="16" height="11" ' + 'class="gm_gprint_loading" id="loading_' + $(this).attr('id') + '" />');

                _upload($(this), dataset, deferred);
            }
        });

        if (promises.length) {
            $.when.apply(undefined, promises).done(function () {
                _send_customizer_data(e, d, dataset);
            }).always(function () {
                var test = 1;
            });
        } else {
            _send_customizer_data(e, d, dataset);
        }
    };

    /**
     * Upload files from customizer form.
     *
     * @private
     */
    var _upload = function _upload(uploadField, dataset, deferred) {
        var filesList = uploadField.get(0).files,
            url = options.requestUrl + '&action=upload&target=' + dataset.target + '&mode=frontend&upload_field_id=' + uploadField.attr('id') + '&products_id=' + dataset.products_id,
            properties_values_ids = [],
            add_to_properties_array_func = function add_to_properties_array_func() {
            properties_values_ids.push($(this).val());
        };

        $('.customizer select[name^="properties_values_ids["]').each(add_to_properties_array_func);
        $('.customizer select[name^="modifiers[property]["]').each(add_to_properties_array_func);
        $('.customizer input[type=radio][name^="modifiers[property]["]:checked').each(add_to_properties_array_func);
        $('.customizer input[type=hidden][name^="modifiers[property]["]').each(add_to_properties_array_func);

        //  removing duplicated ids
        properties_values_ids = properties_values_ids.filter(function (value, index, self) {
            return self.indexOf(value) === index;
        });

        properties_values_ids.forEach(function (value) {
            url += '&properties_values_ids[]=' + value;
        });

        uploadField.fileupload({
            url: url,
            autoUpload: false,
            replaceFileInput: false, // https://github.com/blueimp/jQuery-File-Upload/wiki/Frequently-Asked-Questions#why-is-the-file-input-field-cloned-and-replaced-after-each-selection
            dataType: 'json'
        });

        uploadField.fileupload('send', { files: filesList }).done(function (result) {
            var uploadFieldName = uploadField.attr('id'),
                filename = uploadField.val().replace(/C:\\fakepath\\/i, '');

            dataset[uploadFieldName] = filename;
            uploadField.parent().find('img').remove();
            uploadField.show();

            $btnFake.html(fakeOrigLabel).removeClass("btn-buy-complete").hide().prop("disabled", false);
            $(".throbbler", $btn).remove();
            $btn.show();

            if (result.ERROR) {
                alert(result.ERROR_MESSAGE);
                deferred.reject();
            } else {
                deferred.resolve(result);
            }
        }).fail(function (jqxhr, testStatus, errorThrown) {
            uploadField.parent().find('img').remove();
            uploadField.show();
            deferred.reject();
        });
    };

    /**
     * Send customizer data beloning to a product which is going to be added to the cart.
     *
     * @private
     */
    var _send_customizer_data = function _send_customizer_data(e, d, dataset) {
        ajax = ajax ? ajax.abort() : null;
        ajax = jse.libs.xhr.post({ url: options.requestUrl, data: dataset }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve(e.data.random);
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    /**
     * Send customizer data beloning to a wish list product which is going to be added to the cart.
     *
     * @private
     */
    var _wishlist_to_cart = function _wishlist_to_cart(e, d) {
        if (d.dataset.products_id[0].indexOf('}0') === -1) {
            if (d.deferred) {
                d.deferred.resolve();
            }

            return;
        }

        ajax = ajax ? ajax.abort() : null;

        ajax = jse.libs.xhr.post({
            url: options.requestUrl,
            data: {
                action: 'wishlist_to_cart',
                products_id: d.dataset.products_id[0],
                mode: 'frontend'
            }
        }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve();
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    /**
     * Delete customizer data belonging to a product which is going to be deleted in cart or wish list.
     *
     * @private
     */
    var _delete = function _delete(e, d) {
        if (d.dataset.products_id[0].indexOf('}0') === -1) {
            if (d.deferred) {
                d.deferred.resolve();
            }

            return;
        }

        var action = 'update_wishlist';
        if (options.page === 'cart') {
            action = 'update_cart';
        }

        ajax = ajax ? ajax.abort() : null;

        ajax = jse.libs.xhr.post({
            url: options.requestUrl,
            data: {
                action: action,
                products_id: d.dataset.products_id[0],
                mode: 'frontend'
            }
        }, true);

        ajax.done(function () {
            if (d.deferred) {
                d.deferred.resolve();
            }
        }).fail(function () {
            if (d.deferred) {
                d.deferred.reject();
            }
        });
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        if (options.page === 'product') {
            var random = $(options.uidSelector).attr('name');
            $body.on(jse.libs.theme.events.ADD_CUSTOMIZER_CART(), { action: 'add_cart', target: 'cart', random: random }, _addCustomizerData);
            $body.on(jse.libs.theme.events.ADD_CUSTOMIZER_WISHLIST(), { action: 'add_wishlist', target: 'wishlist', random: random }, _addCustomizerData);
        }

        $body.on(jse.libs.theme.events.WISHLIST_TO_CART(), _wishlist_to_cart);
        $body.on(jse.libs.theme.events.WISHLIST_CART_DELETE(), _delete);

        $('#gm_gprint_tabs li').on('click', function () {
            $window.trigger(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE());
        });

        $window.trigger(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE());

        // jQuery file upload needs to be loaded after jQuery UI.
        var dependencies = [jse.source + '/vendor/blueimp-file-upload/jquery.fileupload.min.js'];

        window.require(dependencies, done);
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
